VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} HeditSub 
   Caption         =   "tag set"
   ClientHeight    =   3585
   ClientLeft      =   45
   ClientTop       =   390
   ClientWidth     =   6795
   OleObjectBlob   =   "HeditSub.frx":0000
   StartUpPosition =   1  'I[i[ tH[̒
End
Attribute VB_Name = "HeditSub"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Public gStat
Public DataName
Dim CopyStkFr(20)
Dim CopyStkTo(20)
Public CopyStkCnt
Public CopyStkMax
Public CallButton
Public imgBrk
Public StopResize


Sub Init(windname, rText, iDataName, iCallButton)

    CopyStkMax = 1
    imgBrk = 1
    StopResize = 0


    gStat = ""
    
    Set CallButton = iCallButton
    
    TextBox1.Value = ""
    imgtag.Value = ""
    imgsize.Caption = ""
    
    TextBox2.Value = ""
    linktag.Value = ""
    
    TextBox3.Value = rText
    fonttag.Value = ""
    DataName = iDataName

    If windname = "img" Then
        MultiPage1.Value = 0
        TextBox1.SetFocus
        
    ElseIf windname = "link" Then
        MultiPage1.Value = 1
        TextBox2.SetFocus
        
    ElseIf windname = "font" Then
        MultiPage1.Value = 2
        ColorSampleONOFF.SetFocus
    ElseIf windname = "imgresize" Then
        MultiPage1.Value = 3
        WWV.SetFocus
    End If
    
    FontSizeVal.Clear
    FontSizeVal.AddItem "8"
    FontSizeVal.AddItem "10"
    FontSizeVal.AddItem "12"
    FontSizeVal.AddItem "14"
    FontSizeVal.AddItem "16"
    FontSizeVal.AddItem "18"
    FontSizeVal.AddItem "20"
    FontSizeVal.AddItem "24"
    FontSizeVal.AddItem "30"
    FontSizeVal.AddItem "32"
    FontSizeVal.AddItem "64"
    
    Dim i
    Border0.Clear
    Border1.Clear
    Border2.Clear
    Border3.Clear
    AllBorder.Clear
    AllBorder.AddItem "0"
    For i = 1 To 10
        Border0.AddItem i
        Border1.AddItem i
        Border2.AddItem i
        Border3.AddItem i
        AllBorder.AddItem i
    Next i
    
    ColorSample.BackColor = RGB(0, 0, 0)
    BackColorSample.BackColor = RGB(&HFF, &HFF, &H66)
    BorderColor.BackColor = RGB(&HFF, 0, 0)
    
    Border0.Value = ""
    Border1.Value = ""
    Border2.Value = ""
    Border3.Value = ""

    ColorSampleONOFF.Value = False
    BackColorSampleONOFF.Value = False
    
    RadSize.Clear
    RadSize.AddItem "3"
    RadSize.AddItem "5"
    RadSize.AddItem "10"
    RadSize.ListIndex = 0
    
    For i = 0 To CopyStkMax
        CopyStkFr(i) = ""
        CopyStkTo(i) = ""
    Next i
    CopyStkCnt = 0
    imgBrk = 0
    

End Sub

Private Sub AllBorder_Change()
    If Val(AllBorder.Value) <> 0 Then
        Border0 = AllBorder.Value
        Border1 = AllBorder.Value
        Border2 = AllBorder.Value
        Border3 = AllBorder.Value
    Else
        Border0 = ""
        Border1 = ""
        Border2 = ""
        Border3 = ""
    End If
    Call MakeFontTag
End Sub

Private Sub BackColorSample_Click()
    Dim Color As Long
    
    'LZȂRg[̐FύX
    Color = ColorDlg.GetColorDlg(BackColorSample.BackColor)
    If Color >= 0 Then
        BackColorSample.BackColor = Color
        Call MakeFontTag
    End If

End Sub

Private Sub BackColorSampleONOFF_Click()
    Call MakeFontTag

End Sub

Private Sub BoldCheck_Click()
    Call MakeFontTag
End Sub

Private Sub BorderColor_Click()
    Dim Color As Long
    
    'LZȂRg[̐FύX
    Color = ColorDlg.GetColorDlg(BorderColor.BackColor)
    If Color > 0 Then
        BorderColor.BackColor = Color
        Call MakeFontTag
    End If

End Sub

Private Sub CheckBox1_Change()
    'target=_blank change
    Call TextBox2_Change
End Sub

Private Sub CheckBox2_Click()
    If CheckBox2.Value = True Then
        BorderColor.BackColor = RGB(255, 0, 0)
        Border0.Value = ""
        Border1.Value = ""
        Border2.Value = "2"
        Border3.Value = ""
    Else
        Border0.Value = ""
        Border1.Value = ""
        Border2.Value = ""
        Border3.Value = ""
    End If
    Call MakeFontTag
End Sub

Private Sub ColorSample_Click()
    Dim Color As Long
    
    'LZȂRg[̐FύX
    Color = ColorDlg.GetColorDlg(ColorSample.BackColor)
    If Color >= 0 Then
        ColorSample.BackColor = Color
        Call MakeFontTag
    End If
End Sub

Private Sub ColorSampleONOFF_Click()
    Call MakeFontTag
End Sub

Private Sub CommandButton10_Click()
    Call DataFeedBack
    Hide
End Sub

Private Sub CommandButton3_Click()
    Call MakeFontTag
End Sub

Private Sub CommandButton4_Click()
    Hide
End Sub

Private Sub CommandButton5_Click()
    Dim path
    path = upload_stack_path
    Call shellexe.run(path, "")
End Sub

Private Sub CommandButton6_Click()
    Dim path
    path = upload_stack_path
    Call shellexe.run(path, "")
End Sub

Private Sub CommandButton7_Click()
    Call DataFeedBack
    Hide
End Sub

Private Sub CommandButton8_Click()
    Call DataFeedBack
    Hide
End Sub

Private Sub CommandButton9_Click()
    Call DataFeedBack
    Hide
End Sub

Private Sub CORNER_Click()
    Call MakeFontTag
End Sub

Private Sub FontSizeVal_Change()
    Call MakeFontTag
End Sub

Function get_ColorTagCode(vval)
    Dim xval
    Dim RedH, GrnH, BluH, ColorTag
    xval = Right("000000" + Hex(vval), 6)
    BluH = Mid(xval, 1, 2)
    GrnH = Mid(xval, 3, 2)
    RedH = Mid(xval, 5, 2)
    get_ColorTagCode = "#" + RedH + GrnH + BluH

End Function

Sub MakeFontTag()
    Dim buff
    Dim vval, xval
    
    Dim ColorTag
    ColorTag = ""
    If ColorSampleONOFF.Value = True Then
        vval = ColorSample.BackColor
        ColorTag = "color:" + get_ColorTagCode(vval) + ";"
    End If
    
    Dim BackColorTag
    If BackColorSampleONOFF.Value = True Then
        vval = BackColorSample.BackColor
        BackColorTag = "background-color:" + get_ColorTagCode(vval) + ";padding:0 3px;margin:0 3px;"
    End If
    
    Dim fSize
    fSize = ""
    If Val(FontSizeVal.Value) <> 0 Then
        fSize = "font-size:" + FontSizeVal.Value + "px;"
    End If
    
    Dim BoldTag
    Dim BoldTagS
    Dim BoldTagE
    BoldTag = ""
    BoldTagS = ""
    BoldTagE = ""
    If BoldCheck.Value = True Then
        'BoldTag = "font-weigth:bold;"
        BoldTagS = "<strong>"
        BoldTagE = "</strong>"
    End If
    
    Dim BorderTag
    Dim BorderTagColor
    vval = BorderColor.BackColor
    BorderTagColor = get_ColorTagCode(vval)
    
    BorderTag = ""
    Dim bordertype
    bordertype = 0
    
    Dim bTop, bRgt, bBtm, bLft
    bTop = Border0.Value
    bRgt = Border1.Value
    bBtm = Border2.Value
    bLft = Border3.Value
    
    If Border0.Value = Border1.Value And Border1.Value = Border2.Value And Border2.Value = Border3.Value Then
        If Border0.Value <> "" Then
            bordertype = 1
        End If
    ElseIf Border0.Value = Border2.Value And Border1.Value = Border3.Value Then
        If Border0.Value = "" And Border1.Value = "" Then
        Else
            bordertype = 2
            If Border0.Value = "" Then
                bTop = "0"
                bBtm = "0"
            End If
            If Border1.Value = "" Then
                bRgt = "0"
                bLft = "0"
            End If
        End If
    ElseIf Border1.Value = Border3.Value Then
        If Border1.Value <> "" Then
            bordertype = 3
            If Border0.Value = "" Then
                bTop = "0"
            End If
            If Border2.Value = "" Then
                bBtm = "0"
            End If
        End If
    Else
        bordertype = 4
    End If
    
    If bordertype = 1 Then
        BorderTag = "border-width:" + bTop + "px;border-style:solid;border-color:" + BorderTagColor + ";"
        
    ElseIf bordertype = 2 Then
        BorderTag = "border-width:" + bTop + "px " + bRgt + "px;border-style:solid;border-color:" + BorderTagColor + ";"
        
    ElseIf bordertype = 3 Then
        BorderTag = "border-width:" + bTop + "px " + bRgt + "px " + bBtm + "px;border-style:solid;border-color:" + BorderTagColor + ";"
        
    Else
        If Border0.Value = "" Then
            bTop = "0"
        End If
        If Border1.Value = "" Then
            bRgt = "0"
        End If
        If Border2.Value = "" Then
            bBtm = "0"
        End If
        If Border3.Value = "" Then
            bLft = "0"
        End If
        If Val(Border0.Value) <> 0 Or Val(Border1.Value) <> 0 Or Val(Border2.Value) <> 0 Or Val(Border3.Value) <> 0 Then
            BorderTag = BorderTag + "border-width:" + bTop + "px " + bRgt + "px " + bBtm + "px " + bLft + "px;border-style:solid;border-color:" + BorderTagColor + ";"
        End If
    End If
    
    Dim CornerTag
    CornerTag = ""
    If BorderTag <> "" And CORNER.Value = True Then
        Dim RadSize_V
        Dim RadSize_H
        RadSize_H = RadSize.Value
        If Val(RadSize_H) <> 0 Then
            RadSize_V = Format("0", RadSize_H * 2)
            CornerTag = "border-radius:" + RadSize_H + "px; -webkit-border-radius:" + RadSize_V + "px; -moz-border-radius:" + RadSize_V + "px;"
        End If
    End If
    
    
    If ColorTag <> "" Or BackColorTag <> "" Or fSize <> "" Or BorderTag <> "" Then
        fonttag.Value = "<span style=""" + ColorTag + BackColorTag + fSize + BorderTag + CornerTag + """>" + BoldTagS + TextBox3.Value + BoldTagE + "</span>"
    Else
        If BoldTagS <> "" Then
            fonttag.Value = BoldTagS + TextBox3.Value + BoldTagE
        Else
            fonttag.Value = TextBox3.Value
        End If
    End If
    On Error GoTo rsm
    fonttag.SetFocus
    fonttag.SelStart = 0
    On Error GoTo 0
    Exit Sub
rsm:
    Resume Next
End Sub

Private Sub CommandButton1_Click()
    Call DataFeedBack
    Hide
End Sub

Sub DataFeedBack()
    If MultiPage1.Value = 0 Then
        gStat = imgtag.Value
        Call CopyStkPush
        
    ElseIf MultiPage1.Value = 1 Then
        gStat = linktag.Value
    
    ElseIf MultiPage1.Value = 2 Then
        Call MakeFontTag
        gStat = fonttag.Value
    
    ElseIf MultiPage1.Value = 3 Then
        gStat = RsImgTag.Value
    
    End If
End Sub

Sub CopyStkPush()
    Dim i
    For i = 0 To CopyStkCnt - 1
        FileCopy CopyStkFr(i), CopyStkTo(i)
        If CheckBox3.Value = True Then
            Kill CopyStkFr(i)
        End If
    Next i
End Sub

Private Sub CommandButton2_Click()
    Dim stat
    stat = FileSelect.Sel("摜,*.png;*.gif;*.jpg")
    If stat <> "" Then
        If Mid(stat, 1, 4) <> "http" Then
            Dim line, w, h
            Call filesub.ImageSize(stat, w, h)
            imgsize.Caption = Format("0", w) + " x " + Format("0", h)
            imgBrk = 1
            imgWV = w
            imgHV = h
            imgWO = w
            imgHO = h
            imgBrk = 0
            
            Dim xdir, xfil, xext
            Call filesub.fnsplit(stat, xdir, xfil, xext)
            TextBox1.Value = xfil + xext
            Call Stack_Upload(stat)
        Else
            TextBox1.Value = stat
        End If
    End If
End Sub

Sub Stack_Upload(file)
    Dim xdir, xfil, xext
    Call filesub.fnsplit(file, xdir, xfil, xext)
    
    Dim toFile
    toFile = upload_stack_path + xfil + xext
    
    If CopyStkCnt <= CopyStkMax Then
        CopyStkFr(CopyStkCnt) = file
        CopyStkTo(CopyStkCnt) = toFile
        CopyStkCnt = CopyStkCnt + 1
    Else
        CallButton.Enabled = False
        CallButton.Caption = "stack max"
    End If

End Sub

Function upload_stack_path()
    Dim PathName
    Dim errflg
    
    errflg = 0
    
    PathName = ActiveWorkbook.path + "\000_uploadpath"
    On Error GoTo rsm
    MkDir PathName
    On Error GoTo 0
    
    PathName = PathName + "\" + DataName
    On Error GoTo rsm
    MkDir PathName
    On Error GoTo 0
    
    upload_stack_path = PathName + "\"
    Exit Function
rsm:
    errflg = 1
    Resume Next
End Function

Private Sub Label12_Click()
    Dim Color As Long
    
    'LZȂRg[̐FύX
    Color = ColorDlg.GetColorDlg(BackColorSample.BackColor)
    If Color >= 0 Then
        BackColorSample.BackColor = Color
        Call MakeFontTag
    End If
End Sub

Private Sub imgHV_Change()
    If imgBrk = 0 Then
        Dim ww, hh
        Call ImgTagMake(TextBox1, imgtag, 0, Val(imgHV.Value), Val(imgWO.Value), Val(imgHO.Value), ww, hh)
        imgBrk = 1
        imgWV.Value = Format("0", ww)
        imgBrk = 0
    End If
End Sub

Private Sub imgWV_Change()
    If imgBrk = 0 Then
        Dim ww, hh
        Call ImgTagMake(TextBox1, imgtag, Val(imgWV.Value), 0, Val(imgWO.Value), Val(imgHO.Value), ww, hh)
        imgBrk = 1
        imgHV.Value = Format("0", hh)
        imgBrk = 0
    End If
End Sub

Private Sub TextBox1_Change()
    Dim ww, hh
    Call ImgTagMake(TextBox1, imgtag, Val(imgWV.Value), Val(imgHV.Value), Val(imgWO.Value), Val(imgHO.Value), ww, hh)
End Sub

Function ImgTagMake(iObj, oObj, iw, ih, nw, nh, ww, hh)

    If iObj.Value <> "" Then
        Dim wo, ho
        Dim wv, hv
        Dim wtag, htag
        wtag = ""
        htag = ""
        wv = iw
        hv = ih
        wo = nw
        ho = nh
        If wv = 0 And hv = 0 Then
        ElseIf wv = 0 Then
            wv = Int(wo * hv / ho)
            wtag = " width=""" + Format("0", wv) + """"
            htag = " height=""" + Format("0", hv) + """"
        ElseIf hv = 0 Then
            hv = Int(wv * ho / wo)
            wtag = " width=""" + Format("0", wv) + """"
            htag = " height=""" + Format("0", hv) + """"
        Else
            wtag = " width=""" + Format("0", wv) + """"
            htag = " height=""" + Format("0", hv) + """"
        End If
        ww = wv
        hh = hv
        Dim xdir, xfil, xext
        Call filesub.fnsplit(iObj.Value, xdir, xfil, xext)
        If Mid(iObj.Value, 1, 4) = "http" Then
            oObj.Value = "<img src=""" + iObj.Value + """" + wtag + htag + ">"
        Else
            oObj.Value = "<img src=""" + "<?php echo site_url(); ?>" + "/wp-content/uploads/" + xfil + xext + """" + wtag + htag + ">"
        End If
    End If
End Function

Private Sub TextBox2_Change()
    Dim targetis
    targetis = ""
    If TextBox2.Value <> "" Then
        If CheckBox1.Value = True Then
            targetis = " target=""_blank"""
        End If
        linktag.Value = "<a href=""" + TextBox2.Value + """" + targetis + ">" + TextBox3.Value + "</a>"
    End If
End Sub

Sub SetResizeData(iBuff)
    Dim buff
    Dim work
    Dim p
    Dim line, w_orgsize, h_orgsize
    
    StopResize = 1
    buff = iBuff
    p = InStr(buff, "src=")
    If p > 0 Then
        buff = htmlSub.Get_TagPara(buff, "src")
        buff = Replace(buff, "<?php echo site_url(); ?>" + "/wp-content/uploads/", HeditSub.upload_stack_path)
    Else
        buff = HeditSub.upload_stack_path + buff
    End If
    HeditSub.OrgFile = buff
    If Mid(buff, 1, 4) <> "http" Then
        Call filesub.ImageSize(buff, w_orgsize, h_orgsize)
        WWO.Value = Format("0", w_orgsize)
        HHO.Value = Format("0", h_orgsize)
    End If
    If InStr(iBuff, "width") > 0 Or InStr(buff, "height") > 0 Then
        work = htmlSub.Get_TagPara(iBuff, "width")
        If work <> "" Then
            WWV.Value = work
        End If
        work = htmlSub.Get_TagPara(iBuff, "height")
        If work <> "" Then
            HHV.Value = work
        End If
    Else
        If Mid(buff, 1, 4) <> "http" Then
            WWV.Value = Format("0", w_orgsize)
            HHV.Value = Format("0", h_orgsize)
        End If
    End If
    'HeditSub.RsImgTag = iBuff
    Dim ww, hh
    Call ImgTagMake(OrgFile, RsImgTag, Val(WWV.Value), Val(HHV.Value), Val(WWO.Value), Val(HHO.Value), ww, hh)
    
    StopResize = 0
End Sub

Private Sub WWV_Change()
    If StopResize = 0 Then
        Dim ww, hh
        Call ImgTagMake(OrgFile, RsImgTag, Val(WWV.Value), 0, Val(WWO.Value), Val(HHO.Value), ww, hh)
        StopResize = 1
        HHV.Value = Format("0", hh)
        StopResize = 0
    End If
End Sub

Private Sub HHV_Change()
    If StopResize = 0 Then
        Dim ww, hh
        Call ImgTagMake(OrgFile, RsImgTag, 0, Val(HHV.Value), Val(WWO.Value), Val(HHO.Value), ww, hh)
        StopResize = 1
        WWV.Value = Format("0", ww)
        StopResize = 0
    End If
End Sub
