Attribute VB_Name = "UserTag"
Option Explicit

Dim UserTagStyle_body(20)
Dim UserTagStyle_name(20)
Public UserTagStyle_list
Public UserTagStyle_cnt
Public UserTagStyle_max

Public UserTagsStr
Public UserTageStr

Sub UserTagInit()
    Dim i
    UserTagStyle_cnt = 0
    UserTagStyle_max = 20
    UserTagStyle_list = ""
    For i = 0 To UserTagStyle_max
        UserTagStyle_name(i) = ""
        UserTagStyle_body(i) = ""
    Next i
End Sub

Function UserTagFileName()
    UserTagFileName = ActiveWorkbook.path + "\000_usertag.txt"
End Function

Sub UserTagReadOn(iObj, bObj)
    Dim errflg
    Dim ifp
    Dim buff
    Dim line
    Dim file
    file = UserTagFileName
    
    iObj.Clear
    UserTagStyle_cnt = 0
    
    ifp = FreeFile
    errflg = 0
    On Error GoTo rsm
    Open file For Input As #ifp
    On Error GoTo 0
    If errflg = 1 Then
        Exit Sub
    End If
    Do While Not EOF(ifp)
        Line Input #ifp, buff
        If Mid(buff, 1, 1) <> "#" Then
            line = buff
            Call UserTagSetOn(buff, -1, iObj)
            If Mid(UserTagsStr, 1, 1) = "@" Then
                If UserTageStr <> "style" Then
                    UserTagStyle_name(UserTagStyle_cnt) = UserTageStr
                Else
                    line = line + Format("0", UserTagStyle_cnt)
                    UserTagStyle_name(UserTagStyle_cnt) = UserTageStr + Format("0", UserTagStyle_cnt)
                End If
                Do While Not EOF(ifp)
                    Line Input #ifp, buff
                    If Mid(buff, 1, 2) = "//" Then
                        Exit Do
                    Else
                        If UserTagStyle_cnt <= UserTagStyle_max Then
                            UserTagStyle_body(UserTagStyle_cnt) = UserTagStyle_body(UserTagStyle_cnt) + UserTagTagAdjust(buff)
                        End If
                    End If
                Loop
                UserTagStyle_cnt = UserTagStyle_cnt + 1
            End If
            iObj.AddItem line
        End If
    Loop
    Close #ifp
    If iObj.ListCount > 0 Then
        iObj.ListIndex = 0
    End If
    
    bObj.Enabled = True
    bObj.Caption = "img"
    Exit Sub
rsm:
    errflg = 1
    Resume Next
End Sub

Sub UserTagSetOn(strval, idx, iObj)
    Dim p
    Dim buff
    Dim i
    
    Dim style_str
    Dim sTagName
    Dim className
    UserTagsStr = ""
    UserTageStr = ""
    
    Dim dlim
    dlim = Chr(13) + Chr(10)
    
    buff = strval + "|"
    p = InStr(buff, "|")
    If p > 0 Then
        buff = Mid(buff, p + 1)
        p = InStr(buff, "|")
        UserTagsStr = Mid(buff, 1, p - 1)
        buff = Mid(buff, p + 1)
        If p > 0 Then
            p = InStr(buff, "|")
            UserTageStr = Mid(buff, 1, p - 1)
            
            UserTagsStr = UserTagTagAdjust(UserTagsStr)
            UserTageStr = UserTagTagAdjust(UserTageStr)
            If idx >= 0 Then
                If Mid(UserTagsStr, 1, 1) = "@" Then
                    sTagName = Mid(UserTagsStr, 2)
                    If Mid(UserTageStr, 1, 5) = "style" Then
                        i = Val(Mid(UserTageStr, 6))
                        UserTagsStr = "<" + sTagName + " style=""" + UserTagStyle_body(i) + """>"
                        UserTageStr = "</" + sTagName + ">"
                        iObj.Value = UserTagInsertString(iObj, UserTagsStr, UserTageStr)
                    Else
                        style_str = ""
                        For i = 0 To UserTagStyle_cnt - 1
                            If UserTagStyle_name(i) = UserTageStr Then
                                style_str = UserTagStyle_body(i)
                            Exit For
                            End If
                        Next i
                        className = UserTageStr
                        UserTagsStr = "<" + sTagName + " class=""" + UserTageStr + """>"
                        UserTageStr = "</" + sTagName + ">"
                        If InStr(UserTagStyle_list, className + "|") <= 0 Then
                            UserTagStyle_list = UserTagStyle_list + className + "|"
                            UserTageStr = UserTageStr + dlim
                            UserTageStr = UserTageStr + "<style>"
                            UserTageStr = UserTageStr + style_str
                            UserTageStr = UserTageStr + "</style>"
                        End If
                        iObj.Value = UserTagInsertString(iObj, UserTagsStr, UserTageStr)
                    End If
                Else
                    iObj.Value = UserTagInsertString(iObj, UserTagsStr, UserTageStr)
                End If
            End If
        End If
    End If
        
End Sub

Function UserTaggetSelString(iObj)
    Dim buff
    Dim fbuf, mbuf, bbuf
    
    UserTaggetSelString = iObj.Value
    buff = iObj.Value
    buff = Replace(buff, Chr(13) + Chr(10), Chr(13))
    UserTaggetSelString = Mid(buff, iObj.SelStart + 1, iObj.SelLength)

End Function

Function UserTagInsertString(iObj, insstr, fotstr)
    Dim buff
    Dim fbuf, mbuf, bbuf
    
    UserTagInsertString = iObj.Value
    buff = iObj.Value
    
    buff = Replace(buff, Chr(13) + Chr(10), Chr(13))
    fbuf = Mid(buff, 1, iObj.SelStart)
    mbuf = Mid(buff, iObj.SelStart + 1, iObj.SelLength)
    bbuf = Mid(buff, iObj.SelStart + iObj.SelLength + 1)
    If fotstr <> "" Then
        If fotstr = "#" Then
            UserTagInsertString = fbuf + insstr + mbuf + bbuf
        Else
            UserTagInsertString = fbuf + insstr + mbuf + fotstr + bbuf
        End If
    Else
        UserTagInsertString = fbuf + insstr + bbuf
    End If
End Function

Function UserTagTagAdjust(vStr)
    Dim wstr
    wstr = vStr
    wstr = strSpCut.Both(wstr)
    wstr = Replace(wstr, "<cr>", Chr(13) + Chr(10))
    UserTagTagAdjust = wstr
End Function

Function UserTagGetString(iObj, fStr, bStr)
    Dim buff
    Dim fbuf, mbuf, bbuf
    
    buff = iObj.Value
    
    buff = Replace(buff, Chr(13) + Chr(10), Chr(13))
    fStr = Replace(Mid(buff, 1, iObj.SelStart), Chr(13), Chr(13) + Chr(10))
    UserTagGetString = Replace(Mid(buff, iObj.SelStart + 1, iObj.SelLength), Chr(13), Chr(13) + Chr(10))
    bStr = Replace(Mid(buff, iObj.SelStart + iObj.SelLength + 1), Chr(13), Chr(13) + Chr(10))
    
End Function

Sub UserTagTboxSelectAll(iObj)
    With iObj
        .SetFocus
        .SelStart = 0
        .SelLength = Len(iObj)
    End With
End Sub

Function UserTagGet(iObj, fbuf, mbuf, bbuf)
    Dim buff
    UserTagGet = iObj.Value
    buff = iObj.Value
    buff = Replace(buff, Chr(13) + Chr(10), Chr(13))
    fbuf = Mid(buff, 1, iObj.SelStart)
    mbuf = Mid(buff, iObj.SelStart + 1, iObj.SelLength)
    bbuf = Mid(buff, iObj.SelStart + iObj.SelLength + 1)
    UserTagGet = iObj.SelStart
End Function
